<div class="front_page_section front_page_section_googlemap<?php
	$geya_scheme = geya_get_theme_option( 'front_page_googlemap_scheme' );
	if ( ! empty( $geya_scheme ) && ! geya_is_inherit( $geya_scheme ) ) {
		echo ' scheme_' . esc_attr( $geya_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( geya_get_theme_option( 'front_page_googlemap_paddings' ) );
	if ( geya_get_theme_option( 'front_page_googlemap_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$geya_css      = '';
		$geya_bg_image = geya_get_theme_option( 'front_page_googlemap_bg_image' );
		if ( ! empty( $geya_bg_image ) ) {
			$geya_css .= 'background-image: url(' . esc_url( geya_get_attachment_url( $geya_bg_image ) ) . ');';
		}
		if ( ! empty( $geya_css ) ) {
			echo ' style="' . esc_attr( $geya_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$geya_anchor_icon = geya_get_theme_option( 'front_page_googlemap_anchor_icon' );
	$geya_anchor_text = geya_get_theme_option( 'front_page_googlemap_anchor_text' );
if ( ( ! empty( $geya_anchor_icon ) || ! empty( $geya_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_googlemap"'
									. ( ! empty( $geya_anchor_icon ) ? ' icon="' . esc_attr( $geya_anchor_icon ) . '"' : '' )
									. ( ! empty( $geya_anchor_text ) ? ' title="' . esc_attr( $geya_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_googlemap_inner
		<?php
		$geya_layout = geya_get_theme_option( 'front_page_googlemap_layout' );
		echo ' front_page_section_layout_' . esc_attr( $geya_layout );
		if ( geya_get_theme_option( 'front_page_googlemap_fullheight' ) ) {
			echo ' geya-full-height sc_layouts_flex sc_layouts_columns_middle';
		}
		?>
		"
			<?php
			$geya_css      = '';
			$geya_bg_mask  = geya_get_theme_option( 'front_page_googlemap_bg_mask' );
			$geya_bg_color_type = geya_get_theme_option( 'front_page_googlemap_bg_color_type' );
			if ( 'custom' == $geya_bg_color_type ) {
				$geya_bg_color = geya_get_theme_option( 'front_page_googlemap_bg_color' );
			} elseif ( 'scheme_bg_color' == $geya_bg_color_type ) {
				$geya_bg_color = geya_get_scheme_color( 'bg_color', $geya_scheme );
			} else {
				$geya_bg_color = '';
			}
			if ( ! empty( $geya_bg_color ) && $geya_bg_mask > 0 ) {
				$geya_css .= 'background-color: ' . esc_attr(
					1 == $geya_bg_mask ? $geya_bg_color : geya_hex2rgba( $geya_bg_color, $geya_bg_mask )
				) . ';';
			}
			if ( ! empty( $geya_css ) ) {
				echo ' style="' . esc_attr( $geya_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_googlemap_content_wrap
		<?php
		if ( 'fullwidth' != $geya_layout ) {
			echo ' content_wrap';
		}
		?>
		">
			<?php
			// Content wrap with title and description
			$geya_caption     = geya_get_theme_option( 'front_page_googlemap_caption' );
			$geya_description = geya_get_theme_option( 'front_page_googlemap_description' );
			if ( ! empty( $geya_caption ) || ! empty( $geya_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'fullwidth' == $geya_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}
					// Caption
				if ( ! empty( $geya_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<h2 class="front_page_section_caption front_page_section_googlemap_caption front_page_block_<?php echo ! empty( $geya_caption ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( $geya_caption, 'geya_kses_content' );
					?>
					</h2>
					<?php
				}

					// Description (text)
				if ( ! empty( $geya_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					?>
					<div class="front_page_section_description front_page_section_googlemap_description front_page_block_<?php echo ! empty( $geya_description ) ? 'filled' : 'empty'; ?>">
					<?php
					echo wp_kses( wpautop( $geya_description ), 'geya_kses_content' );
					?>
					</div>
					<?php
				}
				if ( 'fullwidth' == $geya_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Content (text)
			$geya_content = geya_get_theme_option( 'front_page_googlemap_content' );
			if ( ! empty( $geya_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				if ( 'columns' == $geya_layout ) {
					?>
					<div class="front_page_section_columns front_page_section_googlemap_columns columns_wrap">
						<div class="column-1_3">
					<?php
				} elseif ( 'fullwidth' == $geya_layout ) {
					?>
					<div class="content_wrap">
					<?php
				}

				?>
				<div class="front_page_section_content front_page_section_googlemap_content front_page_block_<?php echo ! empty( $geya_content ) ? 'filled' : 'empty'; ?>">
				<?php
					echo wp_kses( $geya_content, 'geya_kses_content' );
				?>
				</div>
				<?php

				if ( 'columns' == $geya_layout ) {
					?>
					</div><div class="column-2_3">
					<?php
				} elseif ( 'fullwidth' == $geya_layout ) {
					?>
					</div>
					<?php
				}
			}

			// Widgets output
			?>
			<div class="front_page_section_output front_page_section_googlemap_output">
				<?php
				if ( is_active_sidebar( 'front_page_googlemap_widgets' ) ) {
					dynamic_sidebar( 'front_page_googlemap_widgets' );
				} elseif ( current_user_can( 'edit_theme_options' ) ) {
					if ( ! geya_exists_trx_addons() ) {
						geya_customizer_need_trx_addons_message();
					} else {
						geya_customizer_need_widgets_message( 'front_page_googlemap_caption', 'ThemeREX Addons - Google map' );
					}
				}
				?>
			</div>
			<?php

			if ( 'columns' == $geya_layout && ( ! empty( $geya_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) ) {
				?>
				</div></div>
				<?php
			}
			?>
		</div>
	</div>
</div>
