<?php
$geya_woocommerce_sc = geya_get_theme_option( 'front_page_woocommerce_products' );
if ( ! empty( $geya_woocommerce_sc ) ) {
	?><div class="front_page_section front_page_section_woocommerce<?php
		$geya_scheme = geya_get_theme_option( 'front_page_woocommerce_scheme' );
		if ( ! empty( $geya_scheme ) && ! geya_is_inherit( $geya_scheme ) ) {
			echo ' scheme_' . esc_attr( $geya_scheme );
		}
		echo ' front_page_section_paddings_' . esc_attr( geya_get_theme_option( 'front_page_woocommerce_paddings' ) );
		if ( geya_get_theme_option( 'front_page_woocommerce_stack' ) ) {
			echo ' sc_stack_section_on';
		}
	?>"
			<?php
			$geya_css      = '';
			$geya_bg_image = geya_get_theme_option( 'front_page_woocommerce_bg_image' );
			if ( ! empty( $geya_bg_image ) ) {
				$geya_css .= 'background-image: url(' . esc_url( geya_get_attachment_url( $geya_bg_image ) ) . ');';
			}
			if ( ! empty( $geya_css ) ) {
				echo ' style="' . esc_attr( $geya_css ) . '"';
			}
			?>
	>
	<?php
		// Add anchor
		$geya_anchor_icon = geya_get_theme_option( 'front_page_woocommerce_anchor_icon' );
		$geya_anchor_text = geya_get_theme_option( 'front_page_woocommerce_anchor_text' );
		if ( ( ! empty( $geya_anchor_icon ) || ! empty( $geya_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
			echo do_shortcode(
				'[trx_sc_anchor id="front_page_section_woocommerce"'
											. ( ! empty( $geya_anchor_icon ) ? ' icon="' . esc_attr( $geya_anchor_icon ) . '"' : '' )
											. ( ! empty( $geya_anchor_text ) ? ' title="' . esc_attr( $geya_anchor_text ) . '"' : '' )
											. ']'
			);
		}
	?>
		<div class="front_page_section_inner front_page_section_woocommerce_inner
			<?php
			if ( geya_get_theme_option( 'front_page_woocommerce_fullheight' ) ) {
				echo ' geya-full-height sc_layouts_flex sc_layouts_columns_middle';
			}
			?>
				"
				<?php
				$geya_css      = '';
				$geya_bg_mask  = geya_get_theme_option( 'front_page_woocommerce_bg_mask' );
				$geya_bg_color_type = geya_get_theme_option( 'front_page_woocommerce_bg_color_type' );
				if ( 'custom' == $geya_bg_color_type ) {
					$geya_bg_color = geya_get_theme_option( 'front_page_woocommerce_bg_color' );
				} elseif ( 'scheme_bg_color' == $geya_bg_color_type ) {
					$geya_bg_color = geya_get_scheme_color( 'bg_color', $geya_scheme );
				} else {
					$geya_bg_color = '';
				}
				if ( ! empty( $geya_bg_color ) && $geya_bg_mask > 0 ) {
					$geya_css .= 'background-color: ' . esc_attr(
						1 == $geya_bg_mask ? $geya_bg_color : geya_hex2rgba( $geya_bg_color, $geya_bg_mask )
					) . ';';
				}
				if ( ! empty( $geya_css ) ) {
					echo ' style="' . esc_attr( $geya_css ) . '"';
				}
				?>
		>
			<div class="front_page_section_content_wrap front_page_section_woocommerce_content_wrap content_wrap woocommerce">
				<?php
				// Content wrap with title and description
				$geya_caption     = geya_get_theme_option( 'front_page_woocommerce_caption' );
				$geya_description = geya_get_theme_option( 'front_page_woocommerce_description' );
				if ( ! empty( $geya_caption ) || ! empty( $geya_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
					// Caption
					if ( ! empty( $geya_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<h2 class="front_page_section_caption front_page_section_woocommerce_caption front_page_block_<?php echo ! empty( $geya_caption ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( $geya_caption, 'geya_kses_content' );
						?>
						</h2>
						<?php
					}

					// Description (text)
					if ( ! empty( $geya_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
						?>
						<div class="front_page_section_description front_page_section_woocommerce_description front_page_block_<?php echo ! empty( $geya_description ) ? 'filled' : 'empty'; ?>">
						<?php
							echo wp_kses( wpautop( $geya_description ), 'geya_kses_content' );
						?>
						</div>
						<?php
					}
				}

				// Content (widgets)
				?>
				<div class="front_page_section_output front_page_section_woocommerce_output list_products shop_mode_thumbs">
					<?php
					if ( 'products' == $geya_woocommerce_sc ) {
						$geya_woocommerce_sc_ids      = geya_get_theme_option( 'front_page_woocommerce_products_per_page' );
						$geya_woocommerce_sc_per_page = count( explode( ',', $geya_woocommerce_sc_ids ) );
					} else {
						$geya_woocommerce_sc_per_page = max( 1, (int) geya_get_theme_option( 'front_page_woocommerce_products_per_page' ) );
					}
					$geya_woocommerce_sc_columns = max( 1, min( $geya_woocommerce_sc_per_page, (int) geya_get_theme_option( 'front_page_woocommerce_products_columns' ) ) );
					echo do_shortcode(
						"[{$geya_woocommerce_sc}"
										. ( 'products' == $geya_woocommerce_sc
												? ' ids="' . esc_attr( $geya_woocommerce_sc_ids ) . '"'
												: '' )
										. ( 'product_category' == $geya_woocommerce_sc
												? ' category="' . esc_attr( geya_get_theme_option( 'front_page_woocommerce_products_categories' ) ) . '"'
												: '' )
										. ( 'best_selling_products' != $geya_woocommerce_sc
												? ' orderby="' . esc_attr( geya_get_theme_option( 'front_page_woocommerce_products_orderby' ) ) . '"'
													. ' order="' . esc_attr( geya_get_theme_option( 'front_page_woocommerce_products_order' ) ) . '"'
												: '' )
										. ' per_page="' . esc_attr( $geya_woocommerce_sc_per_page ) . '"'
										. ' columns="' . esc_attr( $geya_woocommerce_sc_columns ) . '"'
						. ']'
					);
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
}
