<?php
/**
 * The template to display single post
 *
 * @package GEYA
 * @since GEYA 1.0
 */

// Full post loading
$full_post_loading          = geya_get_value_gp( 'action' ) == 'full_post_loading';

// Prev post loading
$prev_post_loading          = geya_get_value_gp( 'action' ) == 'prev_post_loading';
$prev_post_loading_type     = geya_get_theme_option( 'posts_navigation_scroll_which_block' );

// Position of the related posts
$geya_related_position   = geya_get_theme_option( 'related_position' );

// Type of the prev/next post navigation
$geya_posts_navigation   = geya_get_theme_option( 'posts_navigation' );
$geya_prev_post          = false;
$geya_prev_post_same_cat = geya_get_theme_option( 'posts_navigation_scroll_same_cat' );

// Rewrite style of the single post if current post loading via AJAX and featured image and title is not in the content
if ( ( $full_post_loading 
		|| 
		( $prev_post_loading && 'article' == $prev_post_loading_type )
	) 
	&& 
	! in_array( geya_get_theme_option( 'single_style' ), array( 'style-6' ) )
) {
	geya_storage_set_array( 'options_meta', 'single_style', 'style-6' );
}

do_action( 'geya_action_prev_post_loading', $prev_post_loading, $prev_post_loading_type );

get_header();

while ( have_posts() ) {

	the_post();

	// Type of the prev/next post navigation
	if ( 'scroll' == $geya_posts_navigation ) {
		$geya_prev_post = get_previous_post( $geya_prev_post_same_cat );  // Get post from same category
		if ( ! $geya_prev_post && $geya_prev_post_same_cat ) {
			$geya_prev_post = get_previous_post( false );                    // Get post from any category
		}
		if ( ! $geya_prev_post ) {
			$geya_posts_navigation = 'links';
		}
	}

	// Override some theme options to display featured image, title and post meta in the dynamic loaded posts
	if ( $full_post_loading || ( $prev_post_loading && $geya_prev_post ) ) {
		geya_sc_layouts_showed( 'featured', false );
		geya_sc_layouts_showed( 'title', false );
		geya_sc_layouts_showed( 'postmeta', false );
	}

	// If related posts should be inside the content
	if ( strpos( $geya_related_position, 'inside' ) === 0 ) {
		ob_start();
	}

	// Display post's content
	get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/content', 'single-' . geya_get_theme_option( 'single_style' ) ), 'single-' . geya_get_theme_option( 'single_style' ) );

	// If related posts should be inside the content
	if ( strpos( $geya_related_position, 'inside' ) === 0 ) {
		$geya_content = ob_get_contents();
		ob_end_clean();

		ob_start();
		do_action( 'geya_action_related_posts' );
		$geya_related_content = ob_get_contents();
		ob_end_clean();

		if ( ! empty( $geya_related_content ) ) {
			$geya_related_position_inside = max( 0, min( 9, geya_get_theme_option( 'related_position_inside' ) ) );
			if ( 0 == $geya_related_position_inside ) {
				$geya_related_position_inside = mt_rand( 1, 9 );
			}

			$geya_p_number         = 0;
			$geya_related_inserted = false;
			$geya_in_block         = false;
			$geya_content_start    = strpos( $geya_content, '<div class="post_content' );
			$geya_content_end      = strrpos( $geya_content, '</div>' );

			for ( $i = max( 0, $geya_content_start ); $i < min( strlen( $geya_content ) - 3, $geya_content_end ); $i++ ) {
				if ( $geya_content[ $i ] != '<' ) {
					continue;
				}
				if ( $geya_in_block ) {
					if ( strtolower( substr( $geya_content, $i + 1, 12 ) ) == '/blockquote>' ) {
						$geya_in_block = false;
						$i += 12;
					}
					continue;
				} else if ( strtolower( substr( $geya_content, $i + 1, 10 ) ) == 'blockquote' && in_array( $geya_content[ $i + 11 ], array( '>', ' ' ) ) ) {
					$geya_in_block = true;
					$i += 11;
					continue;
				} else if ( 'p' == $geya_content[ $i + 1 ] && in_array( $geya_content[ $i + 2 ], array( '>', ' ' ) ) ) {
					$geya_p_number++;
					if ( $geya_related_position_inside == $geya_p_number ) {
						$geya_related_inserted = true;
						$geya_content = ( $i > 0 ? substr( $geya_content, 0, $i ) : '' )
											. $geya_related_content
											. substr( $geya_content, $i );
					}
				}
			}
			if ( ! $geya_related_inserted ) {
				if ( $geya_content_end > 0 ) {
					$geya_content = substr( $geya_content, 0, $geya_content_end ) . $geya_related_content . substr( $geya_content, $geya_content_end );
				} else {
					$geya_content .= $geya_related_content;
				}
			}
		}

		geya_show_layout( $geya_content );
	}

	// Comments
	do_action( 'geya_action_before_comments' );
	comments_template();
	do_action( 'geya_action_after_comments' );

	// Related posts
	if ( 'below_content' == $geya_related_position
		&& ( 'scroll' != $geya_posts_navigation || geya_get_theme_option( 'posts_navigation_scroll_hide_related' ) == 0 )
		&& ( ! $full_post_loading || geya_get_theme_option( 'open_full_post_hide_related' ) == 0 )
	) {
		do_action( 'geya_action_related_posts' );
	}

	// Post navigation: type 'scroll'
	if ( 'scroll' == $geya_posts_navigation && ! $full_post_loading ) {
		?>
		<div class="nav-links-single-scroll"
			data-post-id="<?php echo esc_attr( get_the_ID( $geya_prev_post ) ); ?>"
			data-post-link="<?php echo esc_attr( get_permalink( $geya_prev_post ) ); ?>"
			data-post-title="<?php the_title_attribute( array( 'post' => $geya_prev_post ) ); ?>"
			<?php do_action( 'geya_action_nav_links_single_scroll_data', $geya_prev_post ); ?>
		></div>
		<?php
	}
}

get_footer();
