<?php
/**
 * 'Band' template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GEYA
 * @since GEYA 1.71.0
 */

$geya_template_args = get_query_var( 'geya_template_args' );

$geya_columns       = 1;

$geya_expanded      = ! geya_sidebar_present() && geya_get_theme_option( 'expand_content' ) == 'expand';

$geya_post_format   = get_post_format();
$geya_post_format   = empty( $geya_post_format ) ? 'standard' : str_replace( 'post-format-', '', $geya_post_format );

if ( is_array( $geya_template_args ) ) {
	$geya_columns    = empty( $geya_template_args['columns'] ) ? 1 : max( 1, $geya_template_args['columns'] );
	$geya_blog_style = array( $geya_template_args['type'], $geya_columns );
	if ( ! empty( $geya_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $geya_columns > 1 ) {
	    $geya_columns_class = geya_get_column_class( 1, $geya_columns, ! empty( $geya_template_args['columns_tablet']) ? $geya_template_args['columns_tablet'] : '', ! empty($geya_template_args['columns_mobile']) ? $geya_template_args['columns_mobile'] : '' );
				?><div class="<?php echo esc_attr( $geya_columns_class ); ?>"><?php
	}
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_band post_format_' . esc_attr( $geya_post_format ) );
	geya_add_blog_animation( $geya_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$geya_hover      = ! empty( $geya_template_args['hover'] ) && ! geya_is_inherit( $geya_template_args['hover'] )
							? $geya_template_args['hover']
							: geya_get_theme_option( 'image_hover' );
	$geya_components = ! empty( $geya_template_args['meta_parts'] )
							? ( is_array( $geya_template_args['meta_parts'] )
								? $geya_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $geya_template_args['meta_parts'] ) )
								)
							: geya_array_get_keys_by_value( geya_get_theme_option( 'meta_parts' ) );
	geya_show_post_featured( apply_filters( 'geya_filter_args_featured',
		array(
			'no_links'   => ! empty( $geya_template_args['no_links'] ),
			'hover'      => $geya_hover,
			'meta_parts' => $geya_components,
			'thumb_bg'   => true,
			'thumb_ratio'   => '1:1',
			'thumb_size' => ! empty( $geya_template_args['thumb_size'] )
								? $geya_template_args['thumb_size']
								: geya_get_thumb_size( 
								in_array( $geya_post_format, array( 'gallery', 'audio', 'video' ) )
									? ( strpos( geya_get_theme_option( 'body_style' ), 'full' ) !== false
										? 'full'
										: ( $geya_expanded 
											? 'big' 
											: 'medium-square'
											)
										)
									: 'masonry-big'
								)
		),
		'content-band',
		$geya_template_args
	) );

	?><div class="post_content_wrap"><?php

		// Title and post meta
		$geya_show_title = get_the_title() != '';
		$geya_show_meta  = count( $geya_components ) > 0 && ! in_array( $geya_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );
		if ( $geya_show_title ) {
			?>
			<div class="post_header entry-header">
				<?php
				// Categories
				if ( apply_filters( 'geya_filter_show_blog_categories', $geya_show_meta && in_array( 'categories', $geya_components ), array( 'categories' ), 'band' ) ) {
					do_action( 'geya_action_before_post_category' );
					?>
					<div class="post_category">
						<?php
						geya_show_post_meta( apply_filters(
															'geya_filter_post_meta_args',
															array(
																'components' => 'categories',
																'seo'        => false,
																'echo'       => true,
																'cat_sep'    => false,
																),
															'hover_' . $geya_hover, 1
															)
											);
						?>
					</div>
					<?php
					$geya_components = geya_array_delete_by_value( $geya_components, 'categories' );
					do_action( 'geya_action_after_post_category' );
				}
				// Post title
				if ( apply_filters( 'geya_filter_show_blog_title', true, 'band' ) ) {
					do_action( 'geya_action_before_post_title' );
					if ( empty( $geya_template_args['no_links'] ) ) {
						the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
					} else {
						the_title( '<h4 class="post_title entry-title">', '</h4>' );
					}
					do_action( 'geya_action_after_post_title' );
				}
				?>
			</div><!-- .post_header -->
			<?php
		}

		// Post content
		if ( ! isset( $geya_template_args['excerpt_length'] ) && ! in_array( $geya_post_format, array( 'gallery', 'audio', 'video' ) ) ) {
			$geya_template_args['excerpt_length'] = 13;
		}
		if ( apply_filters( 'geya_filter_show_blog_excerpt', empty( $geya_template_args['hide_excerpt'] ) && geya_get_theme_option( 'excerpt_length' ) > 0, 'band' ) ) {
			?>
			<div class="post_content entry-content">
				<?php
				// Post content area
				geya_show_post_content( $geya_template_args, '<div class="post_content_inner">', '</div>' );
				?>
			</div><!-- .entry-content -->
			<?php
		}
		// Post meta
		if ( apply_filters( 'geya_filter_show_blog_meta', $geya_show_meta, $geya_components, 'band' ) ) {
			if ( count( $geya_components ) > 0 ) {
				do_action( 'geya_action_before_post_meta' );
				geya_show_post_meta(
					apply_filters(
						'geya_filter_post_meta_args', array(
							'components' => join( ',', $geya_components ),
							'seo'        => false,
							'echo'       => true,
						), 'band', 1
					)
				);
				do_action( 'geya_action_after_post_meta' );
			}
		}
		// More button
		if ( apply_filters( 'geya_filter_show_blog_readmore', ! $geya_show_title || ! empty( $geya_template_args['more_button'] ), 'band' ) ) {
			if ( empty( $geya_template_args['no_links'] ) ) {
				do_action( 'geya_action_before_post_readmore' );
				geya_show_post_more_link( $geya_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'geya_action_after_post_readmore' );
			}
		}
		?>
	</div>
</article>
<?php

if ( is_array( $geya_template_args ) ) {
	if ( ! empty( $geya_template_args['slider'] ) || $geya_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
