<?php
/**
 * The template to display default site header
 *
 * @package GEYA
 * @since GEYA 1.0
 */

$geya_header_css   = '';
$geya_header_image = get_header_image();
$geya_header_video = geya_get_header_video();
if ( ! empty( $geya_header_image ) && geya_trx_addons_featured_image_override( is_singular() || geya_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$geya_header_image = geya_get_current_mode_image( $geya_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $geya_header_image ) || ! empty( $geya_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $geya_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $geya_header_image ) {
		echo ' ' . esc_attr( geya_add_inline_css_class( 'background-image: url(' . esc_url( $geya_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( geya_is_on( geya_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight geya-full-height';
	}
	$geya_header_scheme = geya_get_theme_option( 'header_scheme' );
	if ( ! empty( $geya_header_scheme ) && ! geya_is_inherit( $geya_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $geya_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $geya_header_video ) ) {
		get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( geya_is_on( geya_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'geya_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
