<?php
/**
 * The template to display the widgets area in the header
 *
 * @package GEYA
 * @since GEYA 1.0
 */

// Header sidebar
$geya_header_name    = geya_get_theme_option( 'header_widgets' );
$geya_header_present = ! geya_is_off( $geya_header_name ) && is_active_sidebar( $geya_header_name );
if ( $geya_header_present ) {
	geya_storage_set( 'current_sidebar', 'header' );
	$geya_header_wide = geya_get_theme_option( 'header_wide' );
	ob_start();
	if ( is_active_sidebar( $geya_header_name ) ) {
		dynamic_sidebar( $geya_header_name );
	}
	$geya_widgets_output = ob_get_contents();
	ob_end_clean();
	if ( ! empty( $geya_widgets_output ) ) {
		$geya_widgets_output = preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $geya_widgets_output );
		$geya_need_columns   = strpos( $geya_widgets_output, 'columns_wrap' ) === false;
		if ( $geya_need_columns ) {
			$geya_columns = max( 0, (int) geya_get_theme_option( 'header_columns' ) );
			if ( 0 == $geya_columns ) {
				$geya_columns = min( 6, max( 1, geya_tags_count( $geya_widgets_output, 'aside' ) ) );
			}
			if ( $geya_columns > 1 ) {
				$geya_widgets_output = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $geya_columns ) . ' widget', $geya_widgets_output );
			} else {
				$geya_need_columns = false;
			}
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo ! empty( $geya_header_wide ) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<?php do_action( 'geya_action_before_sidebar_wrap', 'header' ); ?>
			<div class="header_widgets_inner widget_area_inner">
				<?php
				if ( ! $geya_header_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $geya_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'geya_action_before_sidebar', 'header' );
				geya_show_layout( $geya_widgets_output );
				do_action( 'geya_action_after_sidebar', 'header' );
				if ( $geya_need_columns ) {
					?>
					</div>	<!-- /.columns_wrap -->
					<?php
				}
				if ( ! $geya_header_wide ) {
					?>
					</div>	<!-- /.content_wrap -->
					<?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
			<?php do_action( 'geya_action_after_sidebar_wrap', 'header' ); ?>
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
